IF  EXISTS (SELECT * FROM sys.objects WHERE OBJECT_ID = OBJECT_ID(N'[dbo].[VX_sp_ExtractRoleRecordForIntweb]') AND TYPE IN (N'P', N'PC'))
	DROP PROCEDURE [dbo].[VX_sp_ExtractRoleRecordForIntweb]
GO


CREATE PROCEDURE  [dbo].[VX_sp_ExtractRoleRecordForIntweb]
 @UserId            INT                 = 8,
 @ProjectId         INT                 = 0,
 @UserRoleSets      VARCHAR(MAX)        = '', -- '1,2,3;1,4;1,2,4' ',' -> seperates roles, ';' seperates roleset belonging to same group/agent
 @GlobalRoleSets    VARCHAR(MAX)        = ''

AS

SET NOCOUNT ON;
DECLARE @lockResult INT;
DECLARE @ErrorMessage NVARCHAR(4000);
DECLARE @ErrorSeverity INT;
DECLARE @ErrorState INT;
DECLARE @TraceId BIGINT;
DECLARE @Expired BIT
DECLARE @ExpiredRecordTime DATETIME;
DECLARE @MaxCbDate DATETIME = '9999-12-31T00:00:00Z'

SET @TraceId = null;
SET @ExpiredRecordTime = DATEADD(MINUTE, -5, GETUTCDATE());

EXEC @lockResult = sp_getapplock 'sp_new', 'Exclusive', 'Session', 600000;
IF ( (@lockResult = 0) or (@lockResult = 1)) --- SUCCESS
BEGIN
    BEGIN TRY
        SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

        EXEC sp_UpdateStrataState 0, @UserId;

        CREATE TABLE #ExtractedRecords ( Respondent VARCHAR(10) PRIMARY KEY, ResCall INT, ComputeCB DATETIME, Phone NVARCHAR(100), callbackdate DATETIME, OrderKey INT) 

        BEGIN TRY
            -- Convert @UserRoleSets into a table
            SELECT convert(int, [Role].Value) [Role]
            INTO #SupportedRole
            FROM fn_cte_splitstring(@UserRoleSets, ',') [Role]

            -- Clear all Expired Record
            DELETE FROM dbo.BufferNew WHERE NewDateTime <= @ExpiredRecordTime -- this is 5 minutes delay for a record into BufferNew

            IF (@UserRoleSets = '')
            BEGIN -- Without Roles but Filter with Phone
                INSERT INTO #ExtractedRecords
                    SELECT TOP 1
                            n.Respondent,
                            n.ResCall,
                            COALESCE(CASE WHEN CAST(callbackdate AS INT) <10 THEN @MaxCbDate ELSE callbackdate END, @MaxCbDate) AS ComputedCB, 
                            n.Phone, 
                            n.CallbackDate, 
                            n.OrderKey
                    FROM dbo.BufferNew n WITH (TABLOCKX)
                    WHERE  n.Respondent NOT IN ( SELECT respondent.ResRespondent FROM respondent 
                                                    INNER JOIN Stratum ON ResRespondent = strRespondent 
                                                    INNER JOIN Quota ON strQuotaId = QtQuotaId AND Quota.RoleId IS NOT NULL) AND 
                           n.intgroup = 0 AND
                           n.rescall = 0
                    ORDER BY n.OrderKey

                IF @@ROWCOUNT = 0
                BEGIN  -- No records match the criteria execute an extraction without clearing 
                    EXEC VX_sp_FillCaseBuffer 100, 0, 255, 0, 0 , @UserRoleSets, null, @TraceId OUT, 0, '', 0;

                    INSERT INTO #ExtractedRecords
                        SELECT TOP 1
                                n.Respondent,
                                n.ResCall,
                                COALESCE(CASE WHEN CAST(callbackdate AS INT) <10 THEN @MaxCbDate ELSE callbackdate END, @MaxCbDate) AS ComputedCB, 
                                n.Phone, 
                                n.CallbackDate, 
                                n.OrderKey
                        FROM dbo.BufferNew n WITH (TABLOCKX)
                        WHERE  n.Respondent NOT IN ( SELECT respondent.ResRespondent FROM respondent 
                                                        INNER JOIN Stratum ON ResRespondent = strRespondent 
                                                        INNER JOIN Quota ON strQuotaId = QtQuotaId AND Quota.RoleId IS NOT NULL) AND 
                               n.intgroup = 0 AND
                               n.rescall = 0
                        ORDER BY n.OrderKey
                END
            END  ------------------------------------------
            ELSE -- Roles set is not empty ----------------
            BEGIN------------------------------------------
                INSERT INTO #ExtractedRecords
                SELECT TOP 1
                     n.Respondent,
                     n.ResCall,
                     COALESCE(CASE WHEN CAST(callbackdate AS INT) <10 THEN @MaxCbDate ELSE callbackdate END, @MaxCbDate) AS ComputedCB, 
                     n.Phone, 
                     n.CallbackDate, 
                     n.OrderKey
                FROM dbo.BufferNew n WITH (TABLOCKX)
                WHERE  NOT EXISTS ( SELECT 1 FROM Stratum INNER JOIN Quota ResRole ON StrQuotaId = QtQuotaId 
                                    WHERE StrRespondent = n.Respondent AND RoleId IS NOT NULL AND RoleId NOT IN (SELECT [Role] FROM #SupportedRole) 
                                  ) AND
                       n.intgroup = 0 AND
                       n.rescall = 0
                ORDER BY n.OrderKey

                IF @@ROWCOUNT = 0
                BEGIN  -- No records match the criteria execute an extraction without clearing 
                    EXEC VX_sp_FillCaseBuffer 100, 0, 255, 0, 0 , @GlobalRoleSets, null, @TraceId OUT, 0, '', 0;

                    INSERT INTO #ExtractedRecords
                    SELECT TOP 1
                         n.Respondent,
                         n.ResCall,
                         COALESCE(CASE WHEN CAST(callbackdate AS INT) <10 THEN @MaxCbDate ELSE callbackdate END, @MaxCbDate) AS ComputedCB, 
                         n.Phone, 
                         n.CallbackDate, 
                         n.OrderKey
                    FROM dbo.BufferNew n WITH (TABLOCKX)
                    WHERE  NOT EXISTS ( SELECT 1 FROM Stratum INNER JOIN Quota ResRole ON StrQuotaId = QtQuotaId 
                                        WHERE StrRespondent = n.Respondent AND RoleId IS NOT NULL AND RoleId NOT IN (SELECT [Role] FROM #SupportedRole) 
                                      ) AND
                           n.intgroup = 0 AND
                           n.rescall = 0
                    ORDER BY n.OrderKey

                    IF @@ROWCOUNT = 0
                    BEGIN  -- No records match the criteria even after executing VX_sp_FillCaseBuffer @GlobalRoleSets
                           --   Extract with only UserRoleSets
                        EXEC VX_sp_FillCaseBuffer 100, 0, 255, 0, 0 , @UserRoleSets, null, @TraceId OUT, 0, '', 0;

                        INSERT INTO #ExtractedRecords
                        SELECT TOP 1
                             n.Respondent,
                             n.ResCall,
                             COALESCE(CASE WHEN CAST(callbackdate AS INT) <10 THEN @MaxCbDate ELSE callbackdate END, @MaxCbDate) AS ComputedCB, 
                             n.Phone, 
                             n.CallbackDate, 
                             n.OrderKey
                        FROM dbo.BufferNew n WITH (TABLOCKX)
                        WHERE  NOT EXISTS ( SELECT 1 FROM Stratum INNER JOIN Quota ResRole ON StrQuotaId = QtQuotaId 
                                            WHERE StrRespondent = n.Respondent AND RoleId IS NOT NULL AND RoleId NOT IN (SELECT [Role] FROM #SupportedRole) 
                                          ) AND
                               n.intgroup = 0 AND
                               n.rescall = 0
                        ORDER BY n.OrderKey
                    END
                END
            END

        -- From now on, if a case can suitable for this RoleSet limitation it's now into #ExtractedRecords

        -- Now we need to update different things about the utilisation of that case 
            -------- The Following 2 Queries are directly taken from sp_UpDateForNew
            --------     The Store Procedure was possible for only a record at the time
            --------     We change it to execute the update with a recordset instead of a single Key
            -- Update the records Extracted into Respondent table so that it can't be extracted until it is called or recycled
            UPDATE respondent
            SET    rescall = 1,
                   respreviouscalldate = rescallbackdate,
                   rescallbackdate = 0,
                   projectid = @projectId,
                   modifiedby = @userId,
                   modified = GETUTCDATE()
            WHERE  resrespondent IN (SELECT #ExtractedRecords.Respondent FROM #ExtractedRecords)

            -- Flag use records of the dbo.buffernew so it can't be use a second time
            UPDATE dbo.buffernew
            SET    rescall = 1
            WHERE  respondent IN (SELECT #ExtractedRecords.Respondent FROM #ExtractedRecords)
                   AND intgroup = 0

            --- update quota Online and Unused
            UPDATE quota SET qtOnline= qtOnline + valueonline, qtunused = qtunused - valueUnused
            FROM quota INNER JOIN
                (SELECT strquotaid, SUM(stratum.IncrementValue) valueOnline , SUM(CASE WHEN callbackdate <= 0 THEN stratum.IncrementValue ELSE 0 END) valueUnused
                 FROM #ExtractedRecords INNER JOIN stratum WITH(NOLOCK) ON strrespondent = respondent
                 GROUP BY strquotaid
                ) UsedStratum ON quota.qtquotaid = UsedStratum.strquotaid
            WHERE qtstratum >0;
            -- we decrement the unused for the global quotas
            UPDATE quota SET qtunused = qtunused - (SELECT COUNT(*) FROM #ExtractedRecords WHERE callbackdate <=0)
            WHERE qtstratum = 0
    
            SET NOCOUNT OFF;

            -- this is the return select with the record
            SELECT #ExtractedRecords.* FROM #ExtractedRecords

        END TRY
        BEGIN CATCH
            SELECT 
			    @ErrorMessage = ERROR_MESSAGE() + ':' + isnull(ERROR_PROCEDURE(), '??') + '(' + convert(NVARCHAR(20), ERROR_LINE()) + ')',
                @ErrorSeverity = ERROR_SEVERITY(),
                @ErrorState = ERROR_STATE();
            DROP TABLE #ExtractedRecords;
            DROP TABLE #SupportedRole;
            RAISERROR (@ErrorMessage, -- Message text.
                       @ErrorSeverity, -- Severity.
                       @ErrorState -- State.
                      );
        END CATCH
        -- We remove temporary table from the excution for the workflow of the next time we call this
        DROP TABLE #ExtractedRecords;
        DROP TABLE #SupportedRole;
    END TRY
    BEGIN CATCH
        SELECT 
		    @ErrorMessage = ERROR_MESSAGE() + ':' + isnull(ERROR_PROCEDURE(), '??') + '(' + convert(NVARCHAR(20), ERROR_LINE()) + ')',
            @ErrorSeverity = ERROR_SEVERITY(),
            @ErrorState = ERROR_STATE();

        EXEC @lockResult = sp_releaseapplock 'sp_new', 'Session';
        RAISERROR (@ErrorMessage, -- Message text.
                   @ErrorSeverity, -- Severity.
                   @ErrorState -- State.
                  );
        RETURN;
    END CATCH
    
    EXEC @lockResult = sp_releaseapplock 'sp_new', 'Session';
END
ELSE
BEGIN
    -- raise @lockResult and message about error on Lock sp_new
    RAISERROR ('Error in get application lock', -- Message text.
               -1, -- Severity.
               0 -- State.
              );
    RETURN;
END